<?php

/***********************************************************************************************/
/* 	Define Constants */
/***********************************************************************************************/
define('THEMEROOT', get_stylesheet_directory_uri());
define('IMAGES', THEMEROOT.'/img');
define('JS', THEMEROOT.'/js');

require_once('wp_bootstrap_navwalker.php');
/***********************************************************************************************/
/* Add Menus */
/***********************************************************************************************/
function register_my_menus(){
	register_nav_menus(
		array(
			'top-menu' => __('Top Menu', 'rabbit-framework'),
			'footer-menu'=> __('Footer Menu', 'rabbit-framework'),

		)
	);
}
add_action('init', 'register_my_menus');

add_action('admin_menu','wphidenag');
function wphidenag() {
remove_action( 'admin_notices', 'update_nag', 3 );
}

// icons
function wps_admin_bar() {
    global $wp_admin_bar;

    $wp_admin_bar->remove_menu('about');
    $wp_admin_bar->remove_menu('wporg');
    $wp_admin_bar->remove_menu('documentation');
    $wp_admin_bar->remove_menu('support-forums');
    $wp_admin_bar->remove_menu('feedback');
    //bagian menambahkan link
        $wp_admin_bar->add_menu( array(
            'id'    => 'wp-logo',
            'title' => '<img src="http://topengwayang.com/wp-content/themes/topeng/images/icon.png" />',
            'href'  => self_admin_url( '' ),
            'meta'  => array(
                'title' => __('Service AC'),
            ),
        ) );
}
add_action( 'wp_before_admin_bar_render', 'wps_admin_bar' );

add_filter('nav_menu_css_class' , 'special_nav_class' , 10 , 2);
function special_nav_class($classes, $item){
     if( in_array('current-menu-item', $classes) ){
             $classes[] = 'active ';
     }
     return $classes;
}

/***********************************************************************************************/
/* Set the max width of the uploaded images */
/***********************************************************************************************/
// if (!isset($content_width)) $content_width = 784;

/***********************************************************************************************/
/* Add Theme Support for Post Formats, Post Thumbnails and Automatic Feed Links */
/***********************************************************************************************/
if (function_exists('add_theme_support')) {
	add_theme_support('post-formats', array('link', 'quote', 'gallery', 'video'));
	
	add_theme_support('post-thumbnails', array('post'));
	set_post_thumbnail_size(226, 268, true);
	add_image_size('custom-blog-image', 784, 350);

	add_theme_support('automatic-feed-links');
}


/***********************************************************************************************/
/* Add Sidebar Support */
/***********************************************************************************************/
if (function_exists('register_sidebar')) {
	register_sidebar(
		array(
			'name' => __('Main Footer Left', 'rabbit-frameworkk'),
			'id' => 'main-footer-left',
			'description' => __('The main footer area', 'rabbit-framework'),
				'before_widget' => '<div class="col-md-6 ">',
			'after_widget' => '</div>',
			'before_title' => '<h3 class="text">',
			'after_title' => '</h3><h6 class="text">'
		)
	);
	register_sidebar(
		array(
			'name' => __('Main Footer Middle', 'rabbit-frameworkk'),
			'id' => 'main-footer-middle',
			'description' => __('The main footer area', 'rabbit-framework'),
			'before_widget' => '<div align="center">',
			'after_widget' => '</div>',
			'before_title' => '<h3>',
			'after_title' => '</h3>'
		)
	);
		register_sidebar(
		array(
			'name' => __('Main Footer Right', 'rabbit-frameworkk'),
			'id' => 'main-footer-right',
			'description' => __('The main footer area', 'rabbit-framework'),
			'before_widget' => '<div class="col-md-6" align="right">',
			'after_widget' => '</div>',
			'before_title' => '<h3 class="text">',
			'after_title' => '</h3><h6 class="text">'
		)
	);
}